--[[
	Ensemble de classes de base à utiliser pour la création de nouveaux objets.
	@Class RDM_SupplyRocketBuilding 
	@Class RDM_RocketBase
--]]

-- @Class RDM_SupplyRocketBuilding 
-- Pour la constructiond de Rocket du "fake" building

DefineClass.RDM_SupplyRocketBuilding = { 
	__parents = {"BaseRoverBuilding","RocketLandingSite"},
	rover_class = false,
	rocket_class = false,-- template id
}

function RDM_SupplyRocketBuilding:GameInit()
	CreateGameTimeThread(function()
		g_UITotalRockets = g_UITotalRockets + 1
		local rocket = PlaceBuilding(self.rocket_class or GetRocketClass(), {
			city = UICity,
			name = GenerateRocketName()
		})
	
		UICity:AddToLabel("SupplyRocket", rocket)
		rocket:SetPos(self:GetSpotPos(self:GetSpotBeginIndex("Rocket")))
		rocket:SetAngle(self:GetAngle())
		rocket:SetCommand("Unload")
		rocket.landing_site = PlaceBuilding("RocketLandingSite")
		local pos = self:GetPos()
		rocket.landing_site:SetPos(pos)
		rocket.landing_site:SetAngle(self:GetAngle())
		
		-- local q, r = WorldToHex(pos)
		-- local blds = HexGridGetObjects(ObjectGrid, q, r, nil, nil, function(o)
			-- return IsKindOf(o, "LandingPad") or IsKindOf(o, "TradePad")
		-- end)
		
		-- for _, bld in ipairs(blds) do
			-- bld.rocket_construction = nil
		-- end
		DeleteRocketConstruction(pos)
		DoneObject(self)
	end)
end
 
-- @Class RDM_RocketBase
-- A utiliser pour les nouvelles rockets
DefineClass.RDM_RocketBase = { 
	__parents = {"SupplyRocket"},
 
 	default_label = "SupplyRocket",
	fx_actor_base_class = "FXRocket",
	fx_actor_class = "SupplyRocket",
}
 
function RDM_RocketBase:GameInit()
	self.fx_actor_class = "SupplyRocket"
end

function RDM_RocketBase:GetSkins()
  return empty_table, empty_table
end

function RDM_RocketBase:GetAccumulatedFuel() 
	local extra = self.unload_fuel_request and self.unload_fuel_request:GetActualAmount() or 0	
	local amount = (self.launch_fuel - self.refuel_request:GetActualAmount() + extra) / const.ResourceScale
	if amount < 0 then amount = 0 end
	return  T({"<fuel><icon_Fuel_small>", fuel = amount})
end

function RDM_RocketBase:GetAccumulatedExport() 
	local amount = self:GetStoredExportResourceAmount() / 1000
	
	if self.exported_amount and self.command == "FlyToEarth" then
		amount = self.exported_amount / 1000
	end
	
	return T({"<export><icon_PreciousMetals_small>", export = amount})
end